<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST (you can also use PUT if needed)
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from POST request (parsed from JSON body)
$Data = json_decode(file_get_contents("php://input"), true);

// Assign input data to variables
$blog_id = $Data['blog_id'] ?? null;
$blog_title = $Data['Blog_Title'] ?? null;
$by_name = $Data['By_name'] ?? null;
$description = $Data['description'] ?? null;
$blog_image = $Data['Blog_image'] ?? null;
$date = $Data['date'] ?? null; // Optional, can be null
$category = $Data['Category'] ?? null;
$youtube_link = $Data['Youtube_link'] ?? null; // Optional, can be null
$position = $Data['position'] ?? 0; // Default to 0 if not provided
$active = $Data['active'] ?? 1; // Default active as 1 (active)
$delete_status = $Data['Delete_status'] ?? 0; // Default Delete_status as 0 (not deleted)

// Validate required fields
if (!$blog_id || !$blog_title || !$by_name || !$description || !$category) {
    echo json_encode(["status" => "error", "message" => "Blog ID, Blog Title, Author Name, Description, and Category are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$blog_id = mysqli_real_escape_string($conn, $blog_id);
$blog_title = mysqli_real_escape_string($conn, $blog_title);
$by_name = mysqli_real_escape_string($conn, $by_name);
$description = mysqli_real_escape_string($conn, $description);
$blog_image = mysqli_real_escape_string($conn, $blog_image);
$date = $date ? mysqli_real_escape_string($conn, $date) : null; // Sanitize if provided
$category = mysqli_real_escape_string($conn, $category);
$youtube_link = $youtube_link ? mysqli_real_escape_string($conn, $youtube_link) : null; // Sanitize if provided
$position = intval($position);
$active = intval($active);
$delete_status = intval($delete_status);

// Update query to update the blog record
$query = "UPDATE blogs 
          SET Blog_Title = '$blog_title', By_name = '$by_name', description = '$description', 
              Blog_image = '$blog_image', date = " . ($date ? "'$date'" : "NULL") . ", 
              Category = '$category', Youtube_link = " . ($youtube_link ? "'$youtube_link'" : "NULL") . ", 
              position = $position, active = $active, Delete_status = $delete_status 
          WHERE blog_id = '$blog_id'";

// Execute the query and check for success
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Blog record updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update blog record"]);
}
?>
